#ifndef _H_OTLNp
#define _H_OTLNp

#include "OTLN.h"

#define		OTLNp_CODE_VERSION	1

#define		OTLN_MAGIC		'otln'

/*-------------------- macros -------------------------*/
/* these are some common macros you may want to define */

void	OTLN_Report(short rtn, const char *format, const char *val);
void	OTLN_Report(short rtn, const char *format, short val);

#ifdef	USING_U

	#define OTLNp_LOC(rtn)				U_LOC(OTLN_PKG_ID, (rtn))

	// note: format must be passed with parens around it, e.g. (U_Fmt_S, "Hi!") 
	#define OTLNp_PROB(rtn, format)		U_REPORT(OTLNp_LOC(rtn), U_Sev_PROBLEM, format) 
	#define OTLNp_PROB_S(rtn, string)	U_REPORT_S(OTLNp_LOC(rtn), U_Sev_PROBLEM, string)

	#define OTLNp_FATAL(rtn, format)	U_REPORT(OTLNp_LOC(rtn), U_Sev_FATAL, format) 
	#define OTLNp_FATAL_S(rtn, string)	U_REPORT_S(OTLNp_LOC(rtn), U_Sev_FATAL, string)

	#define OTLNp_STR(str_index)		STR_LOOKUP(OTLN, str_index)
#else
	#include "IC_Errors.h"
	#include "MemUtils.h"

	#define OTLNp_LOC(rtn)				(-1)

	// note: format must be passed with parens around it, e.g. (U_Fmt_S, "Hi!") 
	#define OTLNp_PROB(rtn, format)		OTLN_Report(format) 
	#define OTLNp_PROB_S(rtn, string)	AlertID(string, rtn)

	#define OTLNp_FATAL(rtn, format)	OTLNp_PROB(rtn, format) 
	#define OTLNp_FATAL_S(rtn, string)	OTLNp_PROB_S(rtn, string)

	extern		ErrorString		g_o_errorStrings[];

	#define OTLNp_STR(str_index)	g_o_errorStrings[str_index]
	
	#define	M_TICKCOUNT()				TickCount()
	#define	M_EmptyRect(foo)			EmptyRect(foo)
	#define M_InsetRect(foo, bar, baz)	InsetRect(foo, bar, baz)
	#define M_POINT_IN_RECT(foo, bar) 	PtInRect(foo, &(bar))
	#define	U_ASSERT(foo)				ASSERT(foo)
	typedef unsigned char				u_char;
	typedef unsigned long				u_long;

	#define U_LOCK_DH(h)				(HLock((Handle)h), (*(h)))
	#define U_UNLOCK_RH(h)				(HUnlock((Handle)h))

	#define U_ALLOCN_HANDLE_CLR(loc, type, n, what) \
		(type **)TrackNewHandleClear((what), (u_long)(n)*sizeof(type))

	#define U_ALLOC_HANDLE_CLR(loc, type, what) \
		U_ALLOCN_HANDLE_CLR(loc, type, 1, what);
	
	#define U_FREE_HANDLE(h)	do { if (h) TrackDisposeHandle((Handle)(h)), (h)=NULL; } while(0)

	#define M_ABS(N)			((N) < 0 ? -(N) : (N))

	#define U_MEMCLR(CT, DST)	memclr((DST), (CT))

#endif

/*-------------------- enums and typedefs -------------------------*/

enum {
	OTLN_CellRect_CELL, OTLN_CellRect_LEFT, OTLN_CellRect_CENTER, OTLN_CellRect_RIGHT, 
	OTLN_CellRect_TWIRLY_ARROW, 
	OTLN_CellRect_NUMBER, OTLN_CellRect_ICON, OTLN_CellRect_NAME, 
	OTLN_CellRect_NAME_NUMBER, OTLN_CellRect_NAME_ICON, OTLN_CellRect_NAME_NUMBER_ICON
};
typedef short	OTLN_CellRectType;

Rect		OTLN_GetCellRect(OTLN_OutlineP ol, OTLN_CellRectType type, Rect *cellRect);

typedef struct {
	OTLN_OutlineP					ol;
	OTLN_IterateType				type;
	OTLN_IterateOutlineCallback		callback;
	OTLN_GenericCallbackData		*callbackData;
	short							vertical;
	Rect							cellRect;
} OTLN_IterateOutlineParams;

Err		OTLN_CheckOutlineMagic(int rtn, OTLN_OutlineH outline);
Err		OTLN_CheckOutlineRootMagic(int rtn, OTLN_OutlineH outline);
Err		OTLN_CheckTopicMagic(int rtn, OTLN_TopicH outline);

/**************************************************************
			
	OTLNp_dmInterface.h
										
 **************************************************************/

#define		OTLN_ITERATE_TYPE(type)					((type) & 0x0000000F)
#define		OTLN_ITERATE_MODS(type)					((type) & 0xFFFFFFF0)
#define		OTLN_SET_ITERATE_TYPE(comp, type)		(comp) = ((type) | OTLN_ITERATE_MODS(comp))
#define		OTLN_IS_ITERATE_MOD(type, bit)			(((type) & (bit)) != 0)

#define		kNumTwirlies				7

#define		kCollapsedClosedArrow		0
#define		kUnCollapsedClosedArrow		kNumTwirlies - 1

#define		kCollapsedOpenArrow			kNumTwirlies
#define		kUnCollapsedOpenArrow		kNumTwirlies + 1

#define		kTotalTwirlies				kUnCollapsedOpenArrow + 1

#if defined(OS_MAC)
	typedef	struct {
		short	font;
		short	size;
		Style	style;
	} OTLN_SaveFontInfo;

	Err		OTLN_SaveSetFontInfo(OTLN_OutlineH outline, OTLN_SaveFontInfo *sfi);
	Err		OTLN_RestoreFontInfo(OTLN_SaveFontInfo *sfi);
#endif

Err			OTLN_AllocateTwirlies(void);
Err			OTLN_DisposeTwirlies(void);

Err			OTLN_BlitArrow(short arrow, Rect *destRect);
Err			OTLN_BlitIcon(OTLN_OutlineP ol, short iconRef, Rect *inHere);

Err			OTLNp_RecurseDupTopic(	
	OTLN_TopicH		topic, 
	OTLN_TopicH		dupTopic, 
	OTLN_TopicH		dupTopicMother, 
	OTLN_TopicH		dupTopicPrevSister
);

#endif _H_OTLNp
